#!/bin/bash

# Train
ID="Pretrain-DRL2"
MODE='train'
CHECKPOINT=null
TEACHER_ENABLE=false
TEACHER_LEARN=false
DOMAIN_RANDOM_FRICTION_CART=true

WITH_FRICTION=true
FRICTION_CART=5
ACTUATOR_NOISE=true
DRL_MAGNITUDE=50

RANDOM_SEED=0
TRAIN_RANDOM_RESET=true
EVAL_RANDOM_RESET=true
GAMMA=0

python main.py \
  general.id=${ID} \
  general.mode=${MODE} \
  general.checkpoint=${CHECKPOINT} \
  cartpole.with_friction=${WITH_FRICTION} \
  cartpole.friction_cart=${FRICTION_CART} \
  cartpole.random_reset.seed=${RANDOM_SEED} \
  cartpole.random_reset.train=${TRAIN_RANDOM_RESET} \
  cartpole.random_reset.eval=${EVAL_RANDOM_RESET} \
  cartpole.domain_random.friction_cart.apply=${DOMAIN_RANDOM_FRICTION_CART} \
  ha_teacher.teacher_enable=${TEACHER_ENABLE} \
  ha_teacher.teacher_learn=${TEACHER_LEARN} \
  hp_student.phydrl.gamma=${GAMMA} \
  hp_student.agents.action.magnitude=${DRL_MAGNITUDE}